#include "q3la.h"

player_t::player_t()
{
	init();
}

void player_t::init()
{
	for (int i = 0; i < MAX_WEAPONS; i++) {
		kills[i]	= 0;
		killed[i]	= 0;
		suicides[i]	= 0;
	}
	deaths		= 0;
	mkiol		= 0;
	mkiol_time	= 0;
	next		= 0;
	playtime	= 0;
	skill		= 0;
	bot			= false;
}

player_t::~player_t()
{
	if (next != 0) {
		delete[] next;
	}
	next = 0;
}

player_t* player_t::build_next()
{
	next = new player_t[1];
	return next;
}

player_t player_t::operator= (player_t &other)
{
	for (int i = 0; i < MAX_WEAPONS; i++) {
		kills[i] = other.kills[i];
		killed[i] = other.killed[i];
		suicides[i] = other.suicides[i];
	}
	bot = other.bot;
	deaths = other.deaths;
	mkiol = other.mkiol;
	mkiol_time = other.mkiol_time;
	skill = other.skill;
	strcpy (name, other.name);
	next = other.next;
	playtime = other.playtime;
	return other;
}

unsigned int player_t::get_kills()
{
	return kills[0];
}

unsigned int player_t::get_killed()
{
	return killed[0];
}

unsigned int player_t::get_suicides()
{
	return suicides[0];
}

double player_t::get_skill()
{
	if (skill == 0) {
		skill = (double) get_kills() / (double) (get_killed() + deaths + get_suicides() + 1);
	}
	return skill;
}